//	CFileUrl.c

#include <stdio.h>
#include "FSUtils.h"
#include "CGenerator.h"
#include "CDiskUrl.h"
#include "CFolderUrl.h"
#include "CFileUrl.h"

OSErr		CFileUrl::IFileUrl(
	CDiskUrl			*urlDiskP, 
	CFolderUrl			*urlParentFolderP, 
	Gen_Item			*itemP, 
	EntryIndex			dirIndexS)
{
	OSErr				err = noErr;
	DiskLocSpecUnion	locSpec;
	
	i_itemP			= itemP;
	i_generatorP	= urlParentFolderP->i_generatorP;

	locSpec.pro = SetRboShort(0);

	i_iconSuiteH = NULL;

	err = _inherited::IFile(
		urlDiskP, 
		urlParentFolderP, 
		locSpec, 
		dirIndexS, 
		dirIndexS);
	
	return err;
}

void		CFileUrl::Dispose(void)
{
	if (i_iconSuiteH) {
		DisposeIconSuite((IconSuiteRef)i_iconSuiteH, TRUE);
		i_iconSuiteH = NULL;
	}
	
	_inherited::Dispose();
}

char		*CFileUrl::GetName(char *buf)
{
	_inherited::GetName(buf);
	
	if (buf[0] == 0) {
		Rose_GetName(i_itemP, Gen_Ref_SRC, buf);
		_inherited::SetName(buf);
	}

	return buf;
}

void		CFileUrl::SetName(char *buf)
{
//	Gen_LinkContent		*contentP = Rose_ResolveRef(i_itemP, Gen_Ref_SRC);

//	Rose_SetText(contentP, buf);
//	_inherited::SetName(buf);
}

ulong		CFileUrl::GetPhysicalSize(void)
{
	if (i_physical_sizeL == 0) {
		i_physical_sizeL = _inherited::GetPhysicalSize();
	}
	
	return i_physical_sizeL;
}

ulong		CFileUrl::GetLogicalSize(void)
{
	if (i_logical_sizeL == 0) {
		i_logical_sizeL = _inherited::GetPhysicalSize();
	}

	return i_logical_sizeL;
}

char		*CFileUrl::GetDescription(char *buf)
{
	Gen_LinkContent		*contentP = Rose_ResolveRef(i_itemP, Gen_Ref_DEST);

	switch (contentP->type) {

		case GEN_Link_NONE: {
			strcpy(buf, "Rose Item");
			break;
		}

		case GEN_Link_TEXT: {
			strcpy(buf, "Text");
			break;
		}

		case GEN_Link_PICT_FILE: {
			strcpy(buf, "Pict");
			break;
		}

		case GEN_Link_FILE: {
			strcpy(buf, "File");
			break;
		}

		case GEN_Link_URL: {
			strcpy(buf, "URL");
			break;
		}
	}

	return buf;
}

DateTimeRec		*CFileUrl::GetCreatedTime(DateTimeRec *dt)
{
	*dt = i_itemP->resource.source.date;
	
	return dt;
}

void			CFileUrl::SetCreatedTime(DateTimeRec *dt)
{
	i_itemP->resource.source.date = *dt;
}

DateTimeRec		*CFileUrl::GetModifiedTime(DateTimeRec *dt)
{
	*dt = i_itemP->resource.dest.date;
	
	return dt;
}

void			CFileUrl::SetModifiedTime(DateTimeRec *dt)
{
	i_itemP->resource.dest.date = *dt;
}

DateTimeRec		*CFileUrl::GetModifiedTimeRemote(DateTimeRec *dt)
{
	Gen_LinkContent		*contentP = Rose_ResolveRef(i_itemP, Gen_Ref_DEST);

	switch (contentP->type) {

		case GEN_Link_PICT_FILE:
		case GEN_Link_FILE: {
			DateTimeRec		creDate;
			
			(void)FSpGetFileDates(&contentP->u.file, &creDate, dt);
			break;
		}
	}
	
	return dt;
}

void			CFileUrl::RemoteChanged(void)
{
	DateTimeRec		dt;
	
	SetModifiedTime(GetModifiedTimeRemote(&dt));
	InvalStat(ADFS_Stat_MOD_DATE);
}

void			CFileUrl::SetTimeStamps(DateTimeRec *creDate, DateTimeRec *modDate)
{
	SetCreatedTime(creDate);
	SetModifiedTime(modDate);
}

void			CFileUrl::GetTimeStamps(DateTimeRec *creDate, DateTimeRec *modDate)
{
	GetCreatedTime(creDate);
	GetModifiedTime(modDate);
}

OSErr 		CFileUrl::ReadFile(Byte *buffer, long length)
{
	OSErr	err = noErr;
	
	return err;
}

OSErr 		CFileUrl::WriteFile(Byte *buffer, long length)
{
	OSErr	err = noErr;
	
	return err;
}

ADFS_IconType		CFileUrl::GetIconType(void)
{
	ADFS_IconType	icon = ADFS_Icon_CUSTOM;

	if (!i_iconSuiteH) {
		Gen_LinkContent		*contentP	= Rose_ResolveRef(i_itemP, Gen_Ref_DEST);

		if (
			contentP->type == GEN_Link_FILE
			|| contentP->type == GEN_Link_PICT_FILE
		) {
			i_iconSuiteH = FSpGetIconSuite(&contentP->u.file);
		}
	}
	
	if (i_iconSuiteH) {
		g_iconSuiteH = i_iconSuiteH;
	} else {
		icon = _inherited::GetIconType();
	}

	return icon;
}

ulong			CFileUrl::ADFS_GetBufSize(void)
{
	ulong	size = 1024;
	
	return size;
}


Boolean			CFileUrl::IsForked(void)
{
	return FALSE;
}

OSErr			CFileUrl::ADFS_Read(ushort *bytesRead)
{
	OSErr			err = noErr;
	
	return err;
}

OSErr			CFileUrl::ADFS_Write(ushort *bytesWritten)
{
	OSErr			err = noErr;

	return noErr;
}

OSErr		CFileUrl::ADFS_Open(
	ADFS_IOType	ioType, 
	Boolean		resForkB, 
	char		**bufferP, 
	ulong		*bufSize)
{
	OSErr			err			= noErr;
	
	return _inherited::ADFS_Open(ioType, resForkB, bufferP, bufSize);
}

OSErr		CFileUrl::ADFS_Close(void)
{
	OSErr		err = noErr;
	
	return err;
}

void			CFileUrl::GetAccessBits(Gen_AccessBits *bits)
{
	_inherited::GetAccessBits(bits);
}

void			CFileUrl::SetAccessBits(Gen_AccessBits *bits)
{
	_inherited::SetAccessBits(bits);
}

char		*CFileUrl::GetStorageStr(char *buf256)
{
	sprintf(buf256, "%s", "Some Kinda Thing");

	return buf256;
}


Boolean		CFileUrl::IsDeleted(void)
{
	Boolean		deletedB	= _inherited::IsDeleted();
	
	return deletedB;
}

OSErr		CFileUrl::Delete(Boolean warnB, CDialogCopy *copyP0)
{
	OSErr		err				= noErr;
	
//	if (!err) err = _inherited::Delete(warnB, copyP0);
		
	return err;
}

void			CFileUrl::Open(void)
{
	i_generatorP->Generate(i_itemP);
}

